package com.elitescloud.cloudt.system.dto.req;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;


/**
 * <p>
 * 员工组商品范围
 * </p>
 *
 * @author nc
 * @since 2025-09-09
 */
@Data
@ApiModel
public class SysEmployeeGroupItemParamVO implements Serializable {

	private static final long serialVersionUID = 1L;


	/**
	 * 记录唯一ID
	 */
	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	/**
	 * 员工组ID
	 */
	@ApiModelProperty(value = "员工组ID")
	@NotNull(message = "员工组ID" + "不能为空")
	private Long employeeGroupId;

	/**
	 * 范围类型
	 */
	@ApiModelProperty(value = "范围类型")
	@NotBlank(message = "范围类型" + "不能为空")
	@Size(max = 255, message = "itemScopeType最大长度不得超过255")
	private String itemScopeType;

	/**
	 * 编码
	 */
	@ApiModelProperty(value = "编码")
	@NotBlank(message = "编码" + "不能为空")
	@Size(max = 255, message = "itemScopeCode最大长度不得超过255")
	private String itemScopeCode;

	/**
	 * 名称
	 */
	@ApiModelProperty(value = "名称")
	@NotBlank(message = "名称" + "不能为空")
	@Size(max = 255, message = "itemScopeName最大长度不得超过255")
	private String itemScopeName;

	/**
	 * 别名
	 */
	@ApiModelProperty(value = "别名")
	@NotBlank(message = "别名" + "不能为空")
	@Size(max = 255, message = "itemScopeNameAlias最大长度不得超过255")
	private String itemScopeNameAlias;

	/**
	 * 父级节点编码
	 */
	@ApiModelProperty(value = "父级节点编码")
	@NotBlank(message = "父级节点编码" + "不能为空")
	@Size(max = 255, message = "itemScopeParentCode最大长度不得超过255")
	private String itemScopeParentCode;

	/**
	 * 父级节点编码
	 */
	@ApiModelProperty(value = "父级节点编码")
	@NotBlank(message = "父级节点编码" + "不能为空")
	@Size(max = 255, message = "itemScopeParentName最大长度不得超过255")
	private String itemScopeParentName;

	/**
	 * 描述
	 */
	@ApiModelProperty(value = "描述")
	@NotBlank(message = "描述" + "不能为空")
	@Size(max = 255, message = "itemScopeDescription最大长度不得超过255")
	private String itemScopeDescription;

	/**
	 * 状态
	 */
	@ApiModelProperty(value = "状态")
	@NotBlank(message = "状态" + "不能为空")
	@Size(max = 255, message = "itemScopeStatus最大长度不得超过255")
	private String itemScopeStatus;

}