package com.elitescloud.cloudt.system.dto.req;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.util.Set;

/**
 * 分页查询组织.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/13
 */
@Data
public class SysOrgPageQueryDTO extends AbstractOrderQueryParam {
    @Serial
    private static final long serialVersionUID = 6577525121974223412L;

    @ApiModelProperty(value = "组织ID")
    private Set<Long> ids;

    @ApiModelProperty(value = "组织编码")
    private Set<String> codes;

    @ApiModelProperty(value = "外部组织编码")
    private Set<String> outerCodes;
    @ApiModelProperty(value = "外部组织编码")
    private String outerCode;

    @ApiModelProperty(value = "上级组织ID")
    private Long parentId;
    @ApiModelProperty(value = "上级组织编码")
    private String parentCode;

    @ApiModelProperty(value = "是否行政组织")
    private Boolean executive;

    @ApiModelProperty(value = "组织编码")
    private String code;

    @ApiModelProperty(value = "组织名称")
    private String name;

    @ApiModelProperty(value = "简称")
    private String shortName;

    /**
     * 组织类型
     * <p></p>
     * {@link com.elitescloud.cloudt.system.constant.OrgType}
     */
    @ApiModelProperty(value = "组织类型", notes = "com.elitescloud.cloudt.system.constant.OrgType")
    private String type;

    @ApiModelProperty(value = "是否实体")
    private Boolean entity;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "所属公司ID（系统域的）")
    private Long ouId;

    @ApiModelProperty(value = "所属组织ID", notes = "该组织下的所有子孙组织（包含自己）")
    private Long orgIdBelong;
    @ApiModelProperty(value = "所属组织编码", notes = "该组织下的所有子孙组织（包含自己）")
    private String orgCodeBelong;

    @ApiModelProperty(value = "返回的上级类型（包含自己）", notes = "需要同时返回符合组织类型（com.elitescloud.cloudt.system.constant.OrgType）的上级组织，如返回组织的所属公司，则是返回其上级（包含自己）中是公司类型的组织")
    private String withParentType;

    @ApiModelProperty(value = "外部组织编码不为空的")
    private Boolean ownOuterCode;

    @ApiModelProperty(value = "只返回叶子节点")
    private Boolean onlyLeaf;

    @ApiModelProperty(value = "过滤掉的组织类型", notes = "com.elitescloud.cloudt.system.constant.OrgType")
    private String typeFiltered;

    @ApiModelProperty(value = "过滤掉的上级组织ID")
    private Long parentIdFiltered;
    @ApiModelProperty(value = "过滤掉的上级组织编码")
    private String parentCodeFiltered;

    @ApiModelProperty(value = "过滤掉的所属组织ID")
    private Long orgIdBelongFiltered;
    @ApiModelProperty(value = "过滤掉的所属组织编码")
    private String orgCodeBelongFiltered;
}
