package com.elitescloud.cloudt.system.dto.req;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 分页查询日志参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/4
 */
@Data
public class ThirdApiLogQueryDTO extends AbstractOrderQueryParam {
    @Serial
    private static final long serialVersionUID = -4475285009492049970L;

    @ApiModelProperty(value = "业务类型")
    private String businessType;
    @ApiModelProperty(value = "业务数据key")
    private String businessKey;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 是否是restFul风格接口
     */
    private Boolean restful;

    /**
     * 是否是服务端
     */
    private Boolean server;

    /**
     * 客户端ID
     */
    private String clientId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户名
     */
    private String username;

    /**
     * 请求接口
     */
    private String uri;

    /**
     * 是否请求成功
     */
    private Boolean reqSuccess;

    /**
     * 是否响应成功
     */
    private Boolean respSuccess;

    /**
     * 请求时间-开始时间
     */
    private LocalDateTime reqTimeStart;

    /**
     * 请求时间-截止时间
     */
    private LocalDateTime reqTimeEnd;
}
