/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.system.cacheable.SysCacheEmployeeRpcService;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Component;

@Component
@CloudtCache(type="\u7ec4\u7ec7", name="\u5458\u5de5")
public class SysCacheEmployeeRpcServiceImpl
extends AbstractCacheableService
implements SysCacheEmployeeRpcService {
    @Override
    @CloudtCacheMethod(name="\u6839\u636e\u5458\u5de5ID\u83b7\u53d6\u5458\u5de5\u4fe1\u606f")
    public SysEmployeeBasicDTO getById(Long id) {
        Assert.notNull((Object)id, (String)"\u5458\u5de5ID\u4e3a\u7a7a", (Object[])new Object[0]);
        return (SysEmployeeBasicDTO)this.getRpcService().getById(id).computeData();
    }

    @Override
    @CloudtCacheMethod(name="\u6839\u636e\u5458\u5de5\u7f16\u7801\u83b7\u53d6\u5458\u5de5\u4fe1\u606f")
    public SysEmployeeBasicDTO getByCode(String code) {
        Assert.notBlank((CharSequence)code, (String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        return (SysEmployeeBasicDTO)this.getRpcService().getByCode(code).computeData();
    }

    @Override
    @CloudtCacheMethod(name="\u6839\u636e\u8d26\u53f7ID\u83b7\u53d6\u5458\u5de5\u4fe1\u606f")
    public SysEmployeeBasicDTO getByUserId(Long userId) {
        Assert.notNull((Object)userId, (String)"\u8d26\u53f7ID\u4e3a\u7a7a", (Object[])new Object[0]);
        return (SysEmployeeBasicDTO)this.getRpcService().getByUserId(userId).computeData();
    }

    @Override
    @CloudtCacheMethod(name="\u6839\u636e\u767b\u5f55\u53f7\u83b7\u53d6\u5458\u5de5\u4fe1\u606f")
    public SysEmployeeBasicDTO getByUsername(String username) {
        Assert.notBlank((CharSequence)username, (String)"\u5458\u5de5\u8d26\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        return (SysEmployeeBasicDTO)this.getRpcService().getByUsername(username).computeData();
    }

    @Override
    @CloudtCacheMethod(name="\u83b7\u53d6\u5458\u5de5\u5217\u8868")
    public List<SysEmployeeBasicDTO> listAll() {
        return (List)this.getRpcService().queryList(new EmployeeQueryDTO()).computeData();
    }

    @NotBlank
    public String appCode() {
        return "cloudt-system";
    }

    @NotBlank
    public String code() {
        return "employee";
    }

    private EmployeeRpcService getRpcService() {
        return (EmployeeRpcService)this.getService(EmployeeRpcService.class);
    }
}

