package com.elitescloud.cloudt.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 下一编号周期.
 *
 * @author Kaiser（wang shao）
 * 2023/1/9
 */
public enum NextValuePeriod {
    /**
     * 年份
     */
    Y("年"),
    /**
     * 月份
     */
    M("月"),
    /**
     * 日
     */
    D("日"),
    /**
     * 周
     */
    W("周"),
    ;

    /**
     * 描述
     */
    private final String description;

    NextValuePeriod(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, NextValuePeriod> ALL = Arrays.stream(NextValuePeriod.values())
            .collect(Collectors.toMap(NextValuePeriod::name, t -> t, (t1, t2) -> t1));

    /**
     * 解析
     *
     * @param value 值
     * @return 周期
     */
    public static NextValuePeriod parse(String value) {
        return ALL.get(value);
    }
}
