package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceVO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 平台数据源.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheDatabaseSourceRpcService extends CacheableService {

    /**
     * 获取所有数据源
     *
     * @return 数据源列表
     */
    List<SysPlatformDatabaseSourceVO> getAll();

    /**
     * 根据编码获取
     *
     * @param code 数据源编码
     * @return 数据源信息
     */
    SysPlatformDatabaseSourceVO getByCode(@NotBlank String code);
}
