package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 系统设置.
 * <p>
 * 优先从缓存中获取，没有的话再调用RPC查询
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheSettingRpcService extends CacheableService {

    /**
     * 获取所有设置项
     * <p>
     * 当批量处理时，建议使用该方式
     *
     * @return 设置项列表
     */
    List<SysSettingVO> all();

    /**
     * 根据编码获取设置
     *
     * @param no 设置编码
     * @return 设置项
     */
    SysSettingVO oneByNo(@NotBlank(message = "编号不能为空") String no);
}
