package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheAreaRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.basic, name = "行政区域")
public class SysCacheAreaRpcServiceImpl extends AbstractCacheableService implements SysCacheAreaRpcService {

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "area";
    }

    @CloudtCacheMethod(name = "根据编码获取行政区域信息")
    @Override
    public SysAreaRespDTO getByCode(String areaCode) {
        Assert.hasText(areaCode, "行政区域编码为空");
        return getService(SysAreaRpcService.class).getByAreaCode(areaCode).computeData();
    }

    @CloudtCacheMethod(name = "获取行政区域列表")
    @Override
    public List<SysAreaRespDTO> getAll() {
        return getService(SysAreaRpcService.class).queryAll(false).computeData();
    }
}
