package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheEmployeeRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.org, name = "员工")
public class SysCacheEmployeeRpcServiceImpl extends AbstractCacheableService implements SysCacheEmployeeRpcService {

    @CloudtCacheMethod(name = "根据员工ID获取员工信息")
    @Override
    public SysEmployeeBasicDTO getById(Long id) {
        Assert.notNull(id, "员工ID为空");

        return getRpcService().getById(id).computeData();
    }

    @CloudtCacheMethod(name = "根据员工编码获取员工信息")
    @Override
    public SysEmployeeBasicDTO getByCode(String code) {
        Assert.notBlank(code, "员工编码为空");

        return getRpcService().getByCode(code).computeData();
    }

    @CloudtCacheMethod(name = "根据账号ID获取员工信息")
    @Override
    public SysEmployeeBasicDTO getByUserId(Long userId) {
        Assert.notNull(userId, "账号ID为空");

        return getRpcService().getByUserId(userId).computeData();
    }

    @CloudtCacheMethod(name = "根据登录号获取员工信息")
    @Override
    public SysEmployeeBasicDTO getByUsername(String username) {
        Assert.notBlank(username, "员工账号为空");

        return getRpcService().getByUsername(username).computeData();
    }

    @CloudtCacheMethod(name = "获取员工列表")
    @Override
    public List<SysEmployeeBasicDTO> listAll() {
        return getRpcService().queryList(new EmployeeQueryDTO()).computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "employee";
    }

    private EmployeeRpcService getRpcService() {
        return getService(EmployeeRpcService.class);
    }
}
