package com.elitescloud.cloudt.system.constant;


import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消息类型
 * ces
 * **/
public enum EmployeeGroupItemTypeEnum {
    Tag("SYS", "Tag", "员工组商品范围类型", "标签",1),
    Brand("SYS", "Brand", "员工组商品范围类型", "品牌",2),
    Category("SYS", "Category", "员工组商品范围类型", "品类",3),
    ;

    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    EmployeeGroupItemTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
    public static List<SysUdcVO> getSysUdcVOList() {
        ArrayList<SysUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }

    private static final Map<String, EmployeeGroupItemTypeEnum> ALL = Arrays.stream(EmployeeGroupItemTypeEnum.values())
            .collect(Collectors.toMap(EmployeeGroupItemTypeEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 转换对象
     *
     * @param value
     * @return
     */
    public static EmployeeGroupItemTypeEnum parse(String value) {
        return ALL.get(value);
    }
}
