package com.elitescloud.cloudt.system.dto.req;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 统一查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/6
 */
@Getter
@Setter
public class UnifySqlQueryQueryDTO implements Serializable {
    private static final long serialVersionUID = 7048872921047927943L;

    @NotBlank(message = "应用编码不能为空")
    private String appCode;

    /**
     * sql
     * <p>
     * 如：select * from sys_user where username = :username
     */
    @NotBlank(message = "SQL不能为空")
    private String sql;

    /**
     * 查询条件
     */
    private Map<String, Object> conditions;
}
