package com.elitescloud.cloudt.system.dto.resp;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;


/**
 * <p>
 * 员工组商品范围
 * </p>
 *
 * @author nc
 * @since 2025-09-09
 */
@Data
@ApiModel
public class SysEmployeeGroupItemPageRespVO extends BaseViewModel {

	private static final long serialVersionUID = 1L;


	/**
	 * 员工组ID
	 */
	@ApiModelProperty(value = "员工组ID")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long employeeGroupId;

	/**
	 * 范围类型
	 */
	@ApiModelProperty(value = "范围类型")
	private String itemScopeType;

	/**
	 * 编码
	 */
	@ApiModelProperty(value = "编码")
	private String itemScopeCode;

	/**
	 * 名称
	 */
	@ApiModelProperty(value = "名称")
	private String itemScopeName;

	/**
	 * 别名
	 */
	@ApiModelProperty(value = "别名")
	private String itemScopeNameAlias;

	/**
	 * 父级节点编码
	 */
	@ApiModelProperty(value = "父级节点编码")
	private String itemScopeParentCode;

	/**
	 * 父级节点编码
	 */
	@ApiModelProperty(value = "父级节点编码")
	private String itemScopeParentName;

	/**
	 * 描述
	 */
	@ApiModelProperty(value = "描述")
	private String itemScopeDescription;

	/**
	 * 状态
	 */
	@ApiModelProperty(value = "状态")
	private String itemScopeStatus;

}