package com.elitescloud.cloudt.system.dto.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/25 16:36
 */
@Data
public class SysMsgSendRecordDtlDTO implements Serializable {
    private static final long serialVersionUID = 8372409603234111518L;
    private Long id;
    @ApiModelProperty("消息发送主表")
    private Long msgSendRecordId;

    @ApiModelProperty("消息类型-枚举-模板-自定义")
    private String msgType;

    @ApiModelProperty("发送状态-枚举-发送中，成功，失败")
    private String sendState;

    @ApiModelProperty("发送类型-短信-邮箱-站内信-站内提醒websocket")
    private String sentTypeCode;

    @ApiModelProperty("发送类型名称")
    private String sendTypeName;

    @ApiModelProperty("发送时间开始")
    private LocalDateTime sentTimeStart;

    @ApiModelProperty("发送回执结束")
    private LocalDateTime sentTimeEnd;

    @ApiModelProperty("发送回执信息")
    private String sentEndMessage;

    @ApiModelProperty("发送系统内异常信息")
    private String sentErrMessage;

    @ApiModelProperty("发送人id")
    private String sendUserId;

    @ApiModelProperty("发送人名称")
    private String sendUserName;

    @ApiModelProperty("接收人名称")
    private String recipientUserName;

    @ApiModelProperty("接收人id")
    private String recipientUserId;

    @ApiModelProperty("模板id")
    private Long templateId;

    @ApiModelProperty("模板编码")
    private String templateCode;

    @ApiModelProperty("模板名称")
    private String templateName;

    @ApiModelProperty("主题-暂定udc")
    private String subject;

    @ApiModelProperty("标题内容")
    private String titleContent;

    @ApiModelProperty("消息内容")
    private String messageContent;


    @ApiModelProperty("外部模板id")
    private String externalTemplateId;

    @ApiModelProperty("是否已读")
    private Boolean readFlg;
    @ApiModelProperty("已读时间")
    private String readTime;
    @ApiModelProperty("批量号")
    private String batchUuid;

    @ApiModelProperty("自定义json参数")
    private String customParamJson;
}
