package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.DataRelationQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.DataRelationRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 数据关系服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/22
 */
@FeignClient(name = Application.NAME, path = DataRelationRpcService.URI)
@Validated
@DocumentedFeignApi( description = "数据关系服务接口")
public interface DataRelationRpcService {

    String URI = Application.URI_PREFIX + "/dataRelation";

    /**
     * 根据主数据查询被关联的数据
     *
     * @param queryDTO 查询参数
     * @return 关联的数据列表
     */
    @PostMapping(value = "/query")
    @DocumentedFeignApi( description = "根据主数据查询被关联的数据")
    ApiResult<List<DataRelationRespDTO>> query(@RequestBody DataRelationQueryDTO queryDTO);

    /**
     * 根据被关联的数据查询主数据
     *
     * @param queryDTO 查询参数
     * @return 关联的数据列表
     */
    @PostMapping(value = "/queryByRefData")
    @DocumentedFeignApi( description = "根据被关联的数据查询主数据")
    ApiResult<List<DataRelationRespDTO>> queryByRefData(@RequestBody DataRelationQueryDTO queryDTO);
}
