package com.elitescloud.cloudt.system.vo;

import com.elitescloud.cloudt.system.constant.EmployeeGroupItemTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 员工列表查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/19
 */
@Data
@ApiModel(description = "员工组商品范围")
public class EmployeeGroupItemVO implements Serializable {
    private static final long serialVersionUID = 6783701691521938649L;

    @ApiModelProperty(value = "员工组ID")
    private Long employeeGroupId;

    @ApiModelProperty(value = "范围类型 Tag标签 Brand品牌 Category品类")
    private EmployeeGroupItemTypeEnum itemScopeType;

    @ApiModelProperty(value = "编码")
    private String itemScopeCode;

    @ApiModelProperty(value = "名称")
    private String itemScopeName;
    @ApiModelProperty(value = "别名")
    private String itemScopeNameAlias;

    @ApiModelProperty(value = "父级节点编码")
    private String itemScopeParentCode;

    @ApiModelProperty(value = "父级节点名称")
    private String itemScopeParentName;


    @ApiModelProperty(value = "描述")
    private String itemScopeDescription;

    @ApiModelProperty(value = "状态 0禁用 1启用")
    private String itemScopeStatus;

}
