package com.elitescloud.cloudt.constant;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.cloudt.Application;

import javax.validation.constraints.NotBlank;

/**
 * 税率类型.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/5
 */
public class TaxRateType extends BaseUdc<TaxRateType> {
    private static final long serialVersionUID = -4248809489749873645L;

    public static final TaxRateType INPUT = new TaxRateType("input", "进项税率");
    public static final TaxRateType OUTPUT = new TaxRateType("output", "销项税率");

    public TaxRateType() {
    }

    public TaxRateType(String value) {
        super(value);
    }

    public TaxRateType(String value, String description) {
        super(value, description);
    }

    @Override
    public @NotBlank String getAppCode() {
        return Application.NAME;
    }

    @Override
    public String getUdcCode() {
        return "taxRateType";
    }
}
