package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.system.provider.dto.SysEmpGroupDTO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 员工组.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheEmployeeGroupRpcService extends CacheableService {

    /**
     * 根据员工组获取
     *
     * @param groupCode 员工组编码
     * @return 员工组信息
     */
    SysEmpGroupDTO getByCode(@NotBlank String groupCode);

    /**
     * 根据员工组ID获取
     *
     * @param groupId
     * @return
     */
    SysEmpGroupDTO getById(@NotNull Long groupId);

    /**
     * 获取所有员工组
     *
     * @return
     */
    List<SysEmpGroupDTO> listAll();

    /**
     * 获取员工组下的账号ID
     *
     * @param groupCode 员工组编码
     * @return 账号ID
     */
    List<Long> listUserIdByGroupCode(@NotBlank String groupCode);
}
