package com.elitescloud.cloudt.system.cacheable;

import com.elitescloud.boot.core.support.common.CacheableService;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 账号.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
public interface SysCacheUserRpcService extends CacheableService {

    /**
     * 根据账号ID获取账号信息
     *
     * @param id
     * @return
     */
    SysUserBasicDTO getById(@NotNull Long id);

    /**
     * 根据登录号获取账号信息
     *
     * @param username
     * @return
     */
    SysUserBasicDTO getByUsername(@NotBlank String username);

    /**
     * 获取所有账号信息
     *
     * @return
     */
    List<SysUserBasicDTO> listAll();
}
