package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.boot.model.dto.SysBusinessObjectDTO;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheBusinessObjectRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.provider.extend.SysBusinessObjectRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.basic, name = "业务对象")
public class SysCacheBusinessObjectRpcServiceImpl extends AbstractCacheableService implements SysCacheBusinessObjectRpcService {
    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "businessObject";
    }

    @Override
    public boolean supportTenant() {
        return false;
    }

    @CloudtCacheMethod(name = "获取业务对象列表")
    @Override
    public List<SysBusinessObjectDTO> allBusinessObject() {
        return getService(SysBusinessObjectRpcService.class).allBusinessObject().computeData();
    }

    @CloudtCacheMethod(name = "获取业务对象详细信息")
    @Override
    public SysBusinessObjectDTO getBusinessObjectDetail(String businessObjectCode) {
        return getService(SysBusinessObjectRpcService.class).getBusinessObjectDetail(businessObjectCode).computeData();
    }

    @CloudtCacheMethod(name = "获取业务对象操作列表")
    @Override
    public List<SysBusinessOperationDTO> allOperation() {
        return getService(SysBusinessObjectRpcService.class).allOperation().computeData();
    }
}
