package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheOrgRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.org, name = "行政组织")
public class SysCacheOrgRpcServiceImpl extends AbstractCacheableService implements SysCacheOrgRpcService {

    @CloudtCacheMethod(name = "根据ID获取组织信息")
    @Override
    public SysOrgBasicDTO get(Long orgId) {
        Assert.notNull(orgId, "组织ID为空");
        return getRpcService().getById(orgId).computeData();
    }

    @CloudtCacheMethod(name = "根据编码获取组织信息")
    @Override
    public SysOrgBasicDTO getByCode(String orgCode) {
        Assert.notBlank(orgCode, "组织编码为空");
        return getRpcService().getByCode(orgCode).computeData();
    }

    @CloudtCacheMethod(name = "获取组织列表")
    @Override
    public List<SysOrgBasicDTO> listAll() {
        return getRpcService().queryList(new SysOrgQueryDTO()).computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "org";
    }

    private OrgRpcService getRpcService() {
        return getService(OrgRpcService.class);
    }
}
