package com.elitescloud.cloudt.system.dto;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import javax.validation.constraints.NotNull;


/**
 * <p>
 * 数据变更日志
 * </p>
 *
 * @author nc
 * @since 2025-08-21
 */
@Data
@ApiModel
public class SysDataModifyLogDTO extends BaseViewModel {

	private static final long serialVersionUID = 1L;


    /**
     * 业务数据编码
     */
    @ApiModelProperty(value = "业务数据编码")
    private String dataCode;

    /**
     * 业务数据ID
     */
    @ApiModelProperty(value = "业务数据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long dataId;

    /**
     * 业务单据ID
     */
    @ApiModelProperty(value = "业务单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    /**
     * 业务单据类型(供应商变更,商品变更,客户变更)
     */
    @ApiModelProperty(value = "业务单据类型(供应商变更,商品变更,客户变更)")
    private String masType;
    /**
     * 变更内容Json
     */
    @ApiModelProperty(value = "变更内容Json")
    @NotNull(message = "变更内容Json" + "不能为空")
    private String modifyContentJson;
}
