package com.elitescloud.cloudt.system.dto.req;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 数据关系查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/22
 */
@Getter
@Setter
public class DataRelationQueryDTO implements Serializable {
    private static final long serialVersionUID = 1070081991624699495L;

    /**
     * 数据关系编码
     */
    @NotBlank(message = "数据关系编码为空")
    private String drCode;

    /**
     * 分类编码
     */
    private String catCode;

    /**
     * 数据的标识
     */
    private String dataKey;

    /**
     * 数据的检索属性
     */
    private String dataAttribute;

    /**
     * 数据的扩展信息
     * <p>
     * 不为空时，根据扩展信息进行检索，全部扩展信息都满足才符合条件
     */
    private Map<String, String> dataExt;
}
