package com.elitescloud.cloudt.system.dto.req.msg.custom;

import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * @author : chen.niu
 * @description : 雇员接收人发送-消息发送渠道类型与内容
 * @date : 2023/5/25 13:36
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class EmployeeSentMsgParamDTO implements Serializable {

    @ApiModelProperty("标题")
    private String title;
    @ApiModelProperty("内容")
    private String content;
    @ApiModelProperty("发送渠道类型")
    private MsgSendTypeEnum msgSendTypeEnum;

    @ApiModelProperty("外部模板id")
    private String externalTemplateId;
    @ApiModelProperty("外部模板参数")
    private Map<String, String> externalTemplateParams;
}
