package com.elitescloud.cloudt.system.dto.req.msg.template;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * @author : chen.niu
 * @description : 指定发送类型的 相关发送账号信息
 * @date : 2023/5/31 09:44
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TemplateAssignRecipientUserAccountDTO {
    /**
     * 账号
     */
    @NotBlank(message = "账号不能为空")
    @ApiModelProperty(value = "发送账号", position = 1)
    private String account;
    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", position = 2)
    private String nickName;


    @ApiModelProperty(value = "发送账号备用2", position = 3)
    private String account2;

    @ApiModelProperty(value = "用户名称备用2", position = 4)
    private String nickName2;
    //    @ApiModelProperty(value = "外部模板ID", position = 2)
////    private String externalSystemTemplateId;


}
