package com.elitescloud.cloudt.system.provider.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * MQ消息消费结果.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/28
 */
@Data
public class SysMqConsumeResultDTO implements Serializable {
    private static final long serialVersionUID = 7858509735215000310L;

    /**
     * 消息ID
     */
    @NotBlank(message = "消息ID为空")
    private String messageId;

    /**
     * 消费结果
     */
    @NotNull(message = "消费结果为空")
    private Boolean success;

    /**
     * 消费时间
     */
    private LocalDateTime consumeTime;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 消费者名称
     */
    private String consumerName;

    /**
     * 消费者IP
     */
    private String consumerIp;

    /**
     * 失败原因
     */
    private String failReason;

    /**
     * 消费耗时，毫秒
     */
    private Long costTime;
}
