package com.elitescloud.cloudt.system.provider.dto.save;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 公告保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/29
 */
@Getter
@Setter
public class SysNoticeSaveDTO implements Serializable {
    private static final long serialVersionUID = 448465158913292931L;

    /**
     * 公告标题
     */
    @NotBlank(message = "标题不可为空")
    private String title;

    /**
     * 公告摘要
     */
    private String summaries;

    /**
     * 作者用户ID，为空则取当前用户
     */
    private Long authorId;

    /**
     * 分类，[UDC]cloudt-system:noticeCategory
     * <p>
     * {@link com.elitescloud.cloudt.system.constant.SysNoticeCategory}
     */
    private String category;

    /**
     * 公告类型
     * <p>
     * 业务扩展
     */
    private String noticeType;

    /**
     * 是否置顶
     */
    private Boolean top;

    /**
     * 发布时间
     */
    private LocalDateTime publishTime;

    /**
     * 公告内容
     */
    @NotBlank(message = "公告内容不可为空")
    private String txt;

    /**
     * 公告附件的唯一标识
     */
    private List<String> fileCodes;

    /**
     * 是否是系统公告
     */
    private Boolean sys;

    /**
     * 备注
     */
    private String remark;
}
