package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysDataModifyLogDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.EmployeeSendParamDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(name = Application.NAME, path = SysMsgCustomSendRpcService.URI)
@Validated
public interface SysDataModifyLogRpcService {
    String URI = Application.URI_PREFIX + "/data/modify/log/";

    /**
     * 保存数据变更日志
     * @param param
     * @return
     */
    @PostMapping(value = "/sysDataModifyLogSave")
    ApiResult<String> sysDataModifyLogSave(@RequestBody @Valid SysDataModifyLogDTO param);

}