package com.elitescloud.cloudt.system.dto.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * 站内信保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/11/28
 */
@Getter
@Setter
public class SysSiteMsgSaveDTO implements Serializable {
    private static final long serialVersionUID = -1038316629968390542L;

    /**
     * 发送人账户ID
     * <p>
     * 为空则是系统消息
     */
    @ApiModelProperty(value = "发送人账户ID")
    private Long senderUserId;

    /**
     * 接收人账户ID集合
     */
    @ApiModelProperty(value = "接收人账户ID集合")
    @NotEmpty(message = "接收人账户ID为空")
    private Set<Long> receiverUserIds;

    /**
     * 是否忽略不存在的用户
     * <p>
     * 默认false
     */
    private Boolean ignoreUserNotExist;

    /**
     * 消息标题
     */
    @ApiModelProperty(value = "消息标题")
    @NotBlank(message = "标题为空")
    private String title;

    /**
     * 消息内容
     */
    @ApiModelProperty(value = "消息内容")
    private String content;

    /**
     * 自定义参数
     */
    @ApiModelProperty(value = "自定义参数")
    private Map<String, String> customParams;
}
