package com.elitescloud.cloudt.system.dto.resp;

import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 消息发送结果.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/5
 */
@Data
public class SysMsgSentResultDTO implements Serializable {
    private static final long serialVersionUID = 7324943430970367611L;

    /**
     * 消息记录ID
     * <p>
     * 同消息记录的batch_uuid
     */
    private String recordId;

    /**
     * 各种渠道的发送结果
     */
    private Map<MsgSendTypeEnum, SentTypeResult> resultMap;

    @Data
    public static class SentTypeResult implements Serializable {
        private static final long serialVersionUID = 2075950133684040523L;

        /**
         * 发送开始时间
         */
        private LocalDateTime sentTime;

        /**
         * 发送结束时间
         */
        private LocalDateTime finishTime;

        /**
         * 发送状态
         */
        private MsgSendStateEnum sendState;

        /**
         * 是否全部成功
         */
        private Boolean allSucceed;

        /**
         * 接收人列表
         */
        private List<MsgUser> receiverList;

        /**
         * 发送失败信息
         */
        private String failMsg;
    }

    @Data
    public static class MsgUser implements Serializable {
        private static final long serialVersionUID = -7771667720863496758L;

        /**
         * 接收人ID
         */
        private String userId;

        /**
         * 接收人登录号
         */
        private String username;

        /**
         * 接收人姓名
         */
        private String fullName;

        /**
         * 发送状态
         */
        private MsgSendStateEnum sendState;

        /**
         * 接收账号
         */
        private String account;

        /**
         * 接收账号类型
         * <p>
         * 取值：{@link com.elitescloud.cloudt.system.constant.SysMsgReceiverTypeEnum}
         */
        private String accountType;
    }
}
