/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.org;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="cloudt-system", path="/rpc/cloudt/system/v3/user")
@Validated
@DocumentedFeignApi(description="\u7528\u6237\u8d26\u53f7\u670d\u52a1")
public interface UserRpcService {
    public static final String URI = "/rpc/cloudt/system/v3/user";

    @PostMapping(value={"/upsert"})
    @DocumentedFeignApi(description="\u65b0\u589e\u3001\u66f4\u65b0\u7528\u6237\u8d26\u53f7")
    public ApiResult<Long> upsert(@RequestBody @Valid UserCreateDTO var1);

    @PatchMapping(value={"/update/pwd"})
    @DocumentedFeignApi(description="\u66f4\u65b0\u7528\u6237\u5bc6\u7801")
    public ApiResult<Long> updatePwd(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(name="id") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1, @RequestParam(name="pwd", required=false) String var2);

    @PatchMapping(value={"/update/enabled"})
    @DocumentedFeignApi(description="\u66f4\u65b0\u7528\u6237\u542f\u7528\u72b6\u6001")
    public ApiResult<Long> updateEnabled(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(name="id") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1, @NotNull(message="\u542f\u7528\u72b6\u6001\u4e3a\u7a7a") @RequestParam(name="enabled") @NotNull(message="\u542f\u7528\u72b6\u6001\u4e3a\u7a7a") Boolean var2);

    @PostMapping(value={"/userType/add"})
    @DocumentedFeignApi(description="\u589e\u52a0\u7528\u6237\u8eab\u4efd")
    public ApiResult<Long> addUserType(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(name="id") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1, @NotBlank(message="\u7528\u6237\u8eab\u4efd\u4e3a\u7a7a") @RequestParam(name="userType") @NotBlank(message="\u7528\u6237\u8eab\u4efd\u4e3a\u7a7a") String var2, @RequestParam(name="identityId", required=false) String var3);

    @PostMapping(value={"/userType/del"})
    @DocumentedFeignApi(description="\u5220\u9664\u7528\u6237\u8eab\u4efd")
    public ApiResult<Long> removeUserType(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(name="id") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1, @NotBlank(message="\u7528\u6237\u8eab\u4efd\u4e3a\u7a7a") @RequestParam(name="userType") @NotBlank(message="\u7528\u6237\u8eab\u4efd\u4e3a\u7a7a") String var2, @RequestParam(name="identityId", required=false) String var3);

    @DeleteMapping(value={"/delete"})
    @DocumentedFeignApi(description="\u5220\u9664\u7528\u6237")
    public ApiResult<Long> delete(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(name="id") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1);

    @GetMapping(value={"/getById"})
    @DocumentedFeignApi(description="\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public ApiResult<SysUserBasicDTO> getById(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(name="id") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1);

    @GetMapping(value={"/getByUsername"})
    @DocumentedFeignApi(description="\u6839\u636e\u7528\u6237\u767b\u5f55\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public ApiResult<SysUserBasicDTO> getByUsername(@NotBlank(message="\u767b\u5f55\u53f7\u4e3a\u7a7a") @RequestParam(name="username") @NotBlank(message="\u767b\u5f55\u53f7\u4e3a\u7a7a") String var1);

    @PostMapping(value={"/getByIds"})
    @DocumentedFeignApi(description="\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public ApiResult<List<SysUserBasicDTO>> getByIds(@RequestBody @NotEmpty(message="\u7528\u6237ID\u4e3a\u7a7a") @NotEmpty(message="\u7528\u6237ID\u4e3a\u7a7a") List<Long> var1);

    @GetMapping(value={"/getIdByUsername"})
    @DocumentedFeignApi(description="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237ID")
    public ApiResult<Long> getIdByUsername(@NotBlank(message="\u7528\u6237\u8d26\u53f7\u4e3a\u7a7a") @RequestParam(name="username") @NotBlank(message="\u7528\u6237\u8d26\u53f7\u4e3a\u7a7a") String var1);

    @GetMapping(value={"/getUserByUsername"})
    @DocumentedFeignApi(description="\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    public ApiResult<SysUserDTO> getUserByUsername(@RequestParam(name="username") @NotBlank(message="\u7528\u6237\u540d\u4e3a\u7a7a") @NotBlank(message="\u7528\u6237\u540d\u4e3a\u7a7a") String var1);

    @GetMapping(value={"/getUserByMobile"})
    @DocumentedFeignApi(description="\u6839\u636e\u7528\u6237\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    public ApiResult<SysUserDTO> getUserByMobile(@RequestParam(name="mobile") @NotBlank(message="\u624b\u673a\u53f7\u4e3a\u7a7a") @NotBlank(message="\u624b\u673a\u53f7\u4e3a\u7a7a") String var1);

    @GetMapping(value={"/getUserByEmail"})
    @DocumentedFeignApi(description="\u6839\u636e\u7528\u6237\u90ae\u7bb1\u67e5\u8be2\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    public ApiResult<SysUserDTO> getUserByEmail(@RequestParam(name="email") @NotBlank(message="\u90ae\u7bb1\u4e3a\u7a7a") @NotBlank(message="\u90ae\u7bb1\u4e3a\u7a7a") String var1);

    @GetMapping(value={"/getUserById"})
    @DocumentedFeignApi(description="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    public ApiResult<SysUserDTO> getUserById(@RequestParam(name="userId") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1);

    @GetMapping(value={"/getUserByOpenid"})
    @DocumentedFeignApi(description="\u6839\u636e\u7528\u6237\u5fae\u4fe1\u53f7\u67e5\u8be2\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    public ApiResult<SysUserDTO> getUserByOpenid(@RequestParam(name="appId") @NotBlank(message="appId\u4e3a\u7a7a") @NotBlank(message="appId\u4e3a\u7a7a") String var1, @RequestParam(name="openId") @NotBlank(message="openId\u4e3a\u7a7a") @NotBlank(message="openId\u4e3a\u7a7a") String var2);

    @GetMapping(value={"/exists/username"})
    @DocumentedFeignApi(description="\u5224\u65ad\u7528\u6237\u8d26\u53f7\u662f\u5426\u5b58\u5728")
    public ApiResult<Boolean> existsUsername(@NotBlank(message="\u7528\u6237\u8d26\u53f7\u4e3a\u7a7a") @RequestParam(name="username") @NotBlank(message="\u7528\u6237\u8d26\u53f7\u4e3a\u7a7a") String var1);

    @GetMapping(value={"/exists/mobile"})
    @DocumentedFeignApi(description="\u5224\u65ad\u624b\u673a\u53f7\u662f\u5426\u5b58\u5728")
    public ApiResult<Boolean> existsMobile(@NotBlank(message="\u624b\u673a\u53f7\u4e3a\u7a7a") @RequestParam(name="mobile") @NotBlank(message="\u624b\u673a\u53f7\u4e3a\u7a7a") String var1);

    @GetMapping(value={"/exists/email"})
    @DocumentedFeignApi(description="\u5224\u65ad\u90ae\u7bb1\u662f\u5426\u5b58\u5728")
    public ApiResult<Boolean> existsEmail(@NotBlank(message="\u90ae\u7bb1\u4e3a\u7a7a") @RequestParam(name="email") @NotBlank(message="\u90ae\u7bb1\u4e3a\u7a7a") String var1);

    @GetMapping(value={"/exists/outerKey"})
    @DocumentedFeignApi(description="\u5224\u65ad\u5916\u90e8\u6807\u8bc6\u662f\u5426\u5b58\u5728")
    public ApiResult<Boolean> existsOuterKey(@NotBlank(message="\u5916\u90e8\u6807\u8bc6\u4e3a\u7a7a") @RequestParam(name="outerKey") @NotBlank(message="\u5916\u90e8\u6807\u8bc6\u4e3a\u7a7a") String var1);

    @PostMapping(value={"/query"})
    @DocumentedFeignApi(description="\u67e5\u8be2\u7528\u6237\u5217\u8868")
    public ApiResult<List<SysUserBasicDTO>> queryUser(@NotNull @RequestBody UserQueryDTO var1);

    @PutMapping(value={"/update/mobile"})
    @DocumentedFeignApi(description="\u66f4\u65b0\u624b\u673a\u53f7")
    public ApiResult<Long> updateMobile(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(value="id") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1, @RequestParam(name="mobile", required=false) String var2);

    @PutMapping(value={"/update/email"})
    @DocumentedFeignApi(description="\u66f4\u65b0\u90ae\u7bb1")
    public ApiResult<Long> updateEmail(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(value="id") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1, @RequestParam(name="email", required=false) String var2);

    @PutMapping(value={"/update/outerKey"})
    @DocumentedFeignApi(description="\u66f4\u65b0\u5916\u90e8\u6807\u8bc6")
    public ApiResult<Long> updateOuterKey(@NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @RequestParam(value="id") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long var1, @RequestParam(name="outerKey", required=false) String var2);
}

