package com.elitescloud.cloudt.system.cacheable.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.cacheable.SysCacheMenuRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;
import com.elitescloud.cloudt.system.provider.SysMenuRpcService;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/19
 */
@Component
@CloudtCache(type = SysCacheType.basic, name = "菜单")
public class SysCacheMenuRpcServiceImpl extends AbstractCacheableService implements SysCacheMenuRpcService {

    @CloudtCacheMethod(name = "根据编码获取菜单信息")
    @Override
    public SysPlatformMenusDTO getMenuInfo(String menuCode) {
        Assert.notBlank(menuCode, "菜单编码为空");

        return getRpcService().getMenuInfo(menuCode).computeData();
    }

    @CloudtCacheMethod(name = "根据编码获取菜单及上级菜单信息")
    @Override
    public List<IdCodeNameParam> getMenuWithParents(String menuCode) {
        Assert.notBlank(menuCode, "菜单编码为空");

        return getRpcService().getMenuWithParents(menuCode).computeData();
    }

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "menu";
    }

    @Override
    public boolean supportTenant() {
        return false;
    }

    private SysMenuRpcService getRpcService() {
        return getService(SysMenuRpcService.class);
    }
}
