package com.elitescloud.cloudt.system.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.comm.consumer.dto.ComPaymentTermRpcDTO;
import com.elitescloud.cloudt.comm.consumer.param.ComPaymentTermRpcDtoParam;
import com.elitescloud.cloudt.comm.consumer.service.ComPaymentTermRpcService;
import com.elitescloud.cloudt.system.cacheable.SysCachePaymentTermRpcService;
import com.elitescloud.cloudt.system.constant.SysCacheType;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import java.util.Collections;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/27
 */
@Component
@CloudtCache(type = SysCacheType.extend, name = "支付条款")
public class SysCachePaymentTermRpcServiceImpl extends AbstractCacheableService implements SysCachePaymentTermRpcService {

    @Override
    public @NotBlank String appCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String code() {
        return "paymentTerm";
    }

    @CloudtCacheMethod(name = "根据编码获取支付条款信息")
    @Override
    public ComPaymentTermRpcDTO getByCode(String code) {
        Assert.hasText(code, "编码为空");

        var dataList = queryByRpc(code);
        return dataList.isEmpty() ? null : dataList.get(0);
    }

    @CloudtCacheMethod(name = "获取支付条款列表")
    @Override
    public List<ComPaymentTermRpcDTO> listAll() {
        return queryByRpc(null);
    }

    private List<ComPaymentTermRpcDTO> queryByRpc(String ptCode) {
        ComPaymentTermRpcDtoParam param = new ComPaymentTermRpcDtoParam();
        if (StringUtils.hasText(ptCode)) {
            param.setPtCodes(List.of(ptCode));
        }
        var dataList = getService(ComPaymentTermRpcService.class).findPaymentTermRpcDtoByParam(param);
        return ObjUtil.defaultIfNull(dataList, Collections.emptyList());
    }
}
