package com.elitescloud.cloudt.system.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 数据权限基本规则.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/18
 */
@Getter
@Setter
public abstract class BaseDataSecurityRuleDTO implements Serializable {
    private static final long serialVersionUID = -9030898542558554050L;

    /**
     * @deprecated 已弃用，改用{@link #roleCode}
     */
    @Deprecated(since = "3.3.0")
    private Long roleId;
    /**
     * 角色编码
     */
    private String roleCode;
    /**
     * 权限类型
     * <p>
     * 取值：{@link com.elitescloud.cloudt.system.constant.DataPermissionType}
     */
    private String permissionType;

    /**
     * 关联权限
     */
    private String permissionRef;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 业务对象编码
     */
    private String businessObjectCode;

    /**
     * 业务操作的编码
     */
    private String apiPermissionCode;

    /**
     * 业务操作的请求路径
     */
    private String apiPermissionPath;

    /**
     * 业务操作的请求类型
     */
    private String apiPermissionRequestType;

    /**
     * 菜单编码
     */
    private String menusCode;
}
