package com.elitescloud.cloudt.system.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 数据权限配置
 *
 * @author : chen.niu
 * @date 2023/1/31 22:56
 */
@Getter
@Setter
public class SysDprRoleApiRowColumnRuleDTO implements Serializable {
    private static final long serialVersionUID = -3721507921445100927L;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 租户组织ID
     */
    private Long tenantOrgId;

    /**
     * @deprecated 已弃用，改用{@link #roleCodeList}
     */
    @Deprecated(since = "3.3.0")
    private List<Long> roelIdList;
    /**
     * 角色ID
     */
    private List<String> roleCodeList;

    /**
     * 数据权限行规则配置
     */
    private List<SysDprRoleApiDataRuleListQueryDTO> sysDprRoleApiDataRuleListQueryDTO;

    /**
     * 权限字段配置
     */
    private List<SysDpcRoleApiFieldsDTO> sysDpcRoleApiFieldsDTOList;
}
