package com.elitescloud.cloudt.system.dto.resp;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 员工下属.
 *
 * @author Kaiser（wang shao）
 * @date 2/28/2023
 */
@Data
public class EmployeeUnderlingDTO implements Serializable {
    private static final long serialVersionUID = -1525906865588389010L;

    /**
     * 员工ID
     */
    private Long id;

    /**
     * 员工编码
     */
    private String code;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 登录号
     */
    private String username;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     * <p>
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     * </p>
     */
    private String gender;

    /**
     * 性别
     */
    private String genderName;

    /**
     * 员工类型
     */
    private String type;

    /**
     * 员工类型
     */
    private String typeName;

    /**
     * 职务
     */
    private String duty;

    /**
     * 是否在职
     */
    private Boolean served;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 电话
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 组织名称
     */
    private List<String> orgNames;

    /**
     * 领导ID
     */
    private transient Long leaderEmployeeId;

    /**
     * 下属
     */
    private List<EmployeeUnderlingDTO> underlingList;

    /**
     * 是否有下级员工
     *
     * @return 是否有下级员工
     */
    public Boolean getHasUnderling() {
        return underlingList != null && !underlingList.isEmpty();
    }
}
