package com.elitescloud.cloudt.system.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author Michael Li
 */
@Data
@ApiModel("更新用户密码")
public class SysPasswordUpdate implements Serializable {

    private static final long serialVersionUID = -2086085712564516211L;

    @ApiModelProperty("用户账号ID")
    @NotNull(message = "账号ID为空")
    private Long userId;

    @ApiModelProperty("当前密码")
    @NotBlank(message = "当前密码为空")
    private String currentPassword;

    @ApiModelProperty("新密码")
    @NotBlank(message = "新密码为空")
    private String newPassword;
}
