package com.elitescloud.cloudt.system.provider;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * 应用服务接口.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@FeignClient(name = Application.NAME, path = SysAppRpcService.URI)
@Validated
@DocumentedFeignApi( description = "应用服务接口")
public interface SysAppRpcService {
    String URI = Application.URI_PREFIX + "/app";

    /**
     * 获取所有的应用
     *
     * @return 应用
     */
    @GetMapping(value = "/all")
    @DocumentedFeignApi( description = "应用服务全部查询")
    ApiResult<List<CodeNameParam>> allApp();
}
