package com.elitescloud.cloudt.system.id.rpc;

import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.SysIdRpcService;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Stream;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/13 周五
 */
@RestController
@RequestMapping(value = SysIdRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysIdRpcServiceImpl implements SysIdRpcService {

    @Override
    public ApiResult<Long> generateId() {
        return ApiResult.ok(IdFactory.generateLong());
    }

    @Override
    public ApiResult<List<Long>> generateIds(Integer num) {
        if (num == null || num < 1) {
            num = 1;
        }

        List<Long> ids = Stream.generate(IdFactory::generateLong).limit(num).toList();
        return ApiResult.ok(ids);
    }
}
