package com.elitescloud.cloudt.system.seq.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.SysSeqNumRpcService;
import com.elitescloud.cloudt.system.seq.common.SeqNumFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/11/15
 */
@RestController
@RequestMapping(value = SysSeqNumRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysSeqNumRpcServiceImpl implements SysSeqNumRpcService {

    @Autowired
    private SeqNumFactory seqNumFactory;

    @Override
    public ApiResult<String> generateSampleCode(String appCode, String ruleCode, List<String> runtimeValues) {
        var result = seqNumFactory.generateSampleCode(appCode, ruleCode, runtimeValues);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<String> generateSampleCode(Long ruleId, List<String> runtimeValues) {
        var result = seqNumFactory.generateSampleCode(ruleId, runtimeValues);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<String> generateCode(String appCode, String ruleCode, List<String> runtimeValues) {
        var result = seqNumFactory.generateCode(appCode, ruleCode, runtimeValues);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<String>> generateCode(String appCode, String ruleCode, List<String> runtimeValues, Integer num) {
        var result = seqNumFactory.generateCode(appCode, ruleCode, runtimeValues, num);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<String> generateCode(Long ruleId, List<String> runtimeValues) {
        var result = seqNumFactory.generateCode(ruleId, runtimeValues);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<String>> generateCode(Long ruleId, List<String> runtimeValues, Integer num) {
        var result = seqNumFactory.generateCode(ruleId, runtimeValues, num);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<Long> generateNextNumber(Long nextNumberId, Integer len) {
        var result = seqNumFactory.nextValue(nextNumberId, len);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<Long>> generateNextNumber(Long nextNumberId, Integer len, Integer num) {
        var result = seqNumFactory.nextValue(nextNumberId, len, num);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<Long> generateNextNumber(String appCode, String nextNumberCode, Integer len) {
        var result = seqNumFactory.nextValue(appCode, nextNumberCode, len);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<Long>> generateNextNumber(String appCode, String nextNumberCode, Integer len, Integer num) {
        var result = seqNumFactory.nextValue(appCode, nextNumberCode, len, num);
        return ApiResult.ok(result);
    }
}
