package com.elitescloud.cloudt.system.seq.model.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 保存下一编号信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "保存下一编号信息")
public class SeqNumSaveVO implements Serializable {
    private static final long serialVersionUID = -296393935655158609L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 2, required = true)
    @NotBlank(message = "应用编码为空")
    private String appCode;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码", position = 2, required = true)
    @NotBlank(message = "编码为空")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称", position = 3, required = true)
    @NotBlank(message = "名称为空")
    private String name;

    /**
     * 步长
     */
    @ApiModelProperty(value = "步长", position = 4, required = true)
    @NotNull(message = "步长为空")
    private Integer step;

    /**
     * 下一编号
     */
    @ApiModelProperty(value = "下一编号", position = 5, required = true)
    @NotNull(message = "下一编号为空")
    private Long nextNumber;

    /**
     * 编号周期
     */
    @ApiModelProperty(value = "编号周期", position = 6)
    private String nnPeriod;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 7)
    private Boolean enabled;
}
