/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.seq.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.seq.model.bo.SysSeqRuleBO;
import com.elitescloud.cloudt.system.seq.model.vo.query.SeqRulePageQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformNumberRuleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class SeqRuleRepoProc
extends BaseRepoProc<SysPlatformNumberRuleDO> {
    private static final QSysPlatformNumberRuleDO QDO = QSysPlatformNumberRuleDO.sysPlatformNumberRuleDO;

    public SeqRuleRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateEnabled(@NotNull Long id, boolean enabled) {
        super.updateValue((Path)SeqRuleRepoProc.QDO.enabled, (Object)enabled, id.longValue());
    }

    public void deleteByRuleCode(@NotBlank String appCode, @NotBlank String ruleCode) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{SeqRuleRepoProc.QDO.ruleCode.eq((Object)ruleCode).and((Predicate)SeqRuleRepoProc.QDO.appCode.eq((Object)appCode))});
    }

    public Boolean getEnabled(@NotNull Long id) {
        return (Boolean)super.getValue((Path)SeqRuleRepoProc.QDO.enabled, id.longValue());
    }

    public Long getIdByRuleCode(@NotBlank String appCode, @NotBlank String ruleCode) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SeqRuleRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)SeqRuleRepoProc.QDO.ruleCode.eq((Object)ruleCode).and((Predicate)SeqRuleRepoProc.QDO.appCode.eq((Object)appCode)))).limit(1L)).fetchOne();
    }

    public Long getIdByRuleCode(@NotBlank String ruleCode) {
        return super.getIdByValue((Path)SeqRuleRepoProc.QDO.ruleCode, (Object)ruleCode);
    }

    public boolean existsRuleCode(@NotBlank String appCode, @NotBlank String ruleCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SeqRuleRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)SeqRuleRepoProc.QDO.ruleCode.eq((Object)ruleCode).and((Predicate)SeqRuleRepoProc.QDO.appCode.eq((Object)appCode)))).limit(1L)).fetchOne() != null;
    }

    public boolean existsRuleCode(@NotBlank String ruleCode) {
        return super.exists((Path)SeqRuleRepoProc.QDO.ruleCode, (Object)ruleCode);
    }

    public List<String> allCodes(@NotBlank String appCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SeqRuleRepoProc.QDO.ruleCode).from((EntityPath)QDO)).where((Predicate)SeqRuleRepoProc.QDO.appCode.eq((Object)appCode))).fetch();
    }

    public PagingVO<SysPlatformNumberRuleDO> pageMng(SeqRulePageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(StringUtils.hasText((String)queryVO.getAppCode()), (SimpleExpression)SeqRuleRepoProc.QDO.appCode, (Object)queryVO.getAppCode()).andLike(StringUtils.hasText((String)queryVO.getRuleCode()), (StringExpression)SeqRuleRepoProc.QDO.ruleCode, queryVO.getRuleCode()).andLike(StringUtils.hasText((String)queryVO.getRuleName()), (StringExpression)SeqRuleRepoProc.QDO.ruleName, queryVO.getRuleName()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), SeqRuleRepoProc.QDO.createTime.desc());
    }

    public PagingVO<SysSeqRuleBO> pageBo(int page, int pageSize, @NotBlank String appCode) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanBo()).from((EntityPath)QDO)).where((Predicate)SeqRuleRepoProc.QDO.appCode.eq((Object)appCode));
        return super.queryByPage(jpaQuery, super.ofPage(Integer.valueOf(page), Integer.valueOf(pageSize)));
    }

    public SysSeqRuleBO getBo(long id) {
        return (SysSeqRuleBO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanBo()).from((EntityPath)QDO)).where((Predicate)SeqRuleRepoProc.QDO.id.eq((Object)id))).limit(1L)).fetchOne();
    }

    public SysSeqRuleBO getBo(@NotBlank String appCode, @NotBlank String ruleCode) {
        return (SysSeqRuleBO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanBo()).from((EntityPath)QDO)).where((Predicate)SeqRuleRepoProc.QDO.ruleCode.eq((Object)ruleCode).and((Predicate)SeqRuleRepoProc.QDO.appCode.eq((Object)appCode)))).limit(1L)).fetchOne();
    }

    public SysPlatformNumberRuleDO get(@NotBlank String appCode, @NotBlank String ruleCode) {
        return (SysPlatformNumberRuleDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO).where((Predicate)SeqRuleRepoProc.QDO.ruleCode.eq((Object)ruleCode).and((Predicate)SeqRuleRepoProc.QDO.appCode.eq((Object)appCode)))).limit(1L)).fetchOne();
    }

    private QBean<SysSeqRuleBO> qBeanBo() {
        return Projections.bean(SysSeqRuleBO.class, (Expression[])new Expression[]{SeqRuleRepoProc.QDO.id, SeqRuleRepoProc.QDO.appCode, SeqRuleRepoProc.QDO.ruleCode, SeqRuleRepoProc.QDO.ruleName, SeqRuleRepoProc.QDO.sampleCode, SeqRuleRepoProc.QDO.enabled, SeqRuleRepoProc.QDO.remark, SeqRuleRepoProc.QDO.tenantCustom});
    }
}

