package com.elitescloud.cloudt.system.quartz.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.quartz.model.entity.QSysQuartzTriggerRecordDO;
import com.elitescloud.cloudt.system.quartz.model.entity.SysQuartzTriggerRecordDO;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/21 周日
 */
@Repository()
public class SysQuartzTriggerRecordRepoProc extends BaseRepoProc<SysQuartzTriggerRecordDO> {
    private static final QSysQuartzTriggerRecordDO QDO = QSysQuartzTriggerRecordDO.sysQuartzTriggerRecordDO;

    public SysQuartzTriggerRecordRepoProc() {
        super(QDO);
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateSuccess(long id) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.failMsg, (String) null)
                .set(QDO.fullFailMsg, (String) null)
                .set(QDO.success, true)
                .set(QDO.finishedTime, LocalDateTime.now())
                .where(QDO.id.eq(id))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateFailed(long id, String failReason, String fllFailReason) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.failMsg, failReason)
                .set(QDO.fullFailMsg, fllFailReason)
                .set(QDO.success, false)
                .set(QDO.finishedTime, LocalDateTime.now())
                .where(QDO.id.eq(id))
                .execute();
    }
}
