/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.seq.service;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.constant.NextValuePeriod;
import com.elitescloud.cloudt.system.seq.model.bo.SysSeqNextNumberBO;
import com.elitescloud.cloudt.system.seq.service.repo.SeqNextNumRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNextNumberDO;
import java.time.LocalDateTime;
import java.time.temporal.WeekFields;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class NextNumGenerateService {
    private static final Logger log = LogManager.getLogger(NextNumGenerateService.class);
    private static final int REPEAT_TIMES = 6;
    @Autowired
    private SeqNextNumRepoProc nextNumRepoProc;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private EntityManager entityManager;

    public Long createNextNumberForInit(@NotBlank String appCode, @NotBlank String nnCode) {
        SysPlatformNextNumberDO nextNumberDO = new SysPlatformNextNumberDO();
        nextNumberDO.setAppCode(appCode);
        nextNumberDO.setCode(nnCode);
        nextNumberDO.setName("\u9012\u589e\u5e8f\u5217");
        nextNumberDO.setStep(Integer.valueOf(1));
        nextNumberDO.setNextNumber(Long.valueOf(1L));
        nextNumberDO.setNnTime(LocalDateTime.now());
        nextNumberDO.setVersion(Integer.valueOf(1));
        nextNumberDO.setEnabled(Boolean.valueOf(true));
        nextNumberDO.setInternal(Boolean.valueOf(false));
        this.transactionTemplate.executeWithoutResult(t -> this.entityManager.persist((Object)nextNumberDO));
        return nextNumberDO.getId();
    }

    public List<Long> nextNumber(@NotNull Long nnId, Integer nnLen, int num) {
        return (List)this.transactionTemplate.execute(transactionStatus -> {
            SysSeqNextNumberBO nextNumberBO = this.nextNumRepoProc.getBo(nnId);
            if (nextNumberBO == null) {
                throw new BusinessException("\u672a\u627e\u5230\u4e0b\u4e00\u5e8f\u53f7[" + nnId + "]");
            }
            AtomicReference<SysSeqNextNumberBO> nextNumberAtomic = new AtomicReference<SysSeqNextNumberBO>(nextNumberBO);
            Long min = this.buildNextNumber(nextNumberAtomic, nnLen, num);
            if (min == null) {
                return Collections.emptyList();
            }
            long max = Objects.requireNonNull(nextNumberAtomic.get().getNextNumber(), "\u751f\u6210\u4e0b\u4e00\u5e8f\u53f7\u5f02\u5e38");
            return Stream.iterate(min, t -> t < max, t -> t + (long)((SysSeqNextNumberBO)nextNumberAtomic.get()).getStep().intValue()).collect(Collectors.toList());
        });
    }

    private Long buildNextNumber(AtomicReference<SysSeqNextNumberBO> nextNumberAtomic, Integer nnLen, int num) {
        LocalDateTime nowTime = LocalDateTime.now();
        SysSeqNextNumberBO nextNumberBO = nextNumberAtomic.get();
        for (int i = 0; i <= 6; ++i) {
            Long nextNumber = this.generateNextNumber(nextNumberBO, nnLen, nowTime);
            long theNextNum = nextNumber + (long)(nextNumberBO.getStep() == null || nextNumberBO.getStep() <= 0 ? 1 : nextNumberBO.getStep()) * (long)num;
            boolean success = this.nextNumRepoProc.updateValue(nextNumberBO.getId(), theNextNum, nowTime, nextNumberBO.getVersion());
            if (success) {
                log.info("{}\u6210\u529f\u751f\u6210\u4e0b\u4e00\u5e8f\u53f7\uff1a{}\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a{}", (Object)nextNumberBO.getCode(), (Object)nextNumber, (Object)i);
                nextNumberBO.setNextNumber(theNextNum);
                nextNumberAtomic.set(nextNumberBO);
                return nextNumber;
            }
            log.info("{}\u5931\u8d25\u751f\u6210\u4e0b\u4e00\u5e8f\u53f7\uff1a{}\uff0c\u91cd\u8bd5\u7b2c{}\u6b21", (Object)nextNumberBO.getCode(), (Object)nextNumber, (Object)i);
            nextNumberBO = this.nextNumRepoProc.getBo(nextNumberBO.getId());
        }
        log.warn("{}\u751f\u6210\u4e0b\u4e00\u5e8f\u53f7\u5931\u8d25", (Object)nextNumberBO.getCode());
        return null;
    }

    private Long generateNextNumber(SysSeqNextNumberBO nextNumberBO, Integer nnLen, LocalDateTime nowTime) {
        if (CharSequenceUtil.isNotBlank((CharSequence)nextNumberBO.getNnPeriod()) && nextNumberBO.getNnTime() != null) {
            NextValuePeriod period = NextValuePeriod.parse((String)nextNumberBO.getNnPeriod());
            if (period == null) {
                return nextNumberBO.getNextNumber();
            }
            boolean isSameYear = nowTime.getYear() == nextNumberBO.getNnTime().getYear();
            switch (period) {
                case D: {
                    int nowD = nowTime.getDayOfYear();
                    int nnD = nextNumberBO.getNnTime().getDayOfYear();
                    if (!isSameYear || nowD != nnD) {
                        return 1L;
                    }
                    return nextNumberBO.getNextNumber();
                }
                case W: {
                    if (!isSameYear || nowTime.get(WeekFields.ISO.weekOfWeekBasedYear()) != nextNumberBO.getNnTime().get(WeekFields.ISO.weekOfWeekBasedYear())) {
                        return 1L;
                    }
                    return nextNumberBO.getNextNumber();
                }
                case M: {
                    if (!isSameYear || nowTime.getMonthValue() != nextNumberBO.getNnTime().getMonthValue()) {
                        return 1L;
                    }
                    return nextNumberBO.getNextNumber();
                }
                case Y: {
                    if (!isSameYear) {
                        return 1L;
                    }
                    return nextNumberBO.getNextNumber();
                }
            }
            return nextNumberBO.getNextNumber();
        }
        if (nnLen != null && (double)nextNumberBO.getNextNumber().longValue() >= Math.pow(10.0, nnLen.intValue())) {
            return 1L;
        }
        return nextNumberBO.getNextNumber();
    }
}

