/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.quartz.model.bo.schedule;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerType;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.SysQuartzTrigger;
import org.quartz.DateBuilder;
import org.quartz.Trigger;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;

public class IntervalCalendarSysQuartzTrigger
implements SysQuartzTrigger {
    private static final long serialVersionUID = -1991548270265263447L;
    private Integer interval;
    private IntervalUnit intervalUnit;

    public IntervalCalendarSysQuartzTrigger() {
    }

    public IntervalCalendarSysQuartzTrigger(Integer interval, IntervalUnit intervalUnit) {
        this.interval = interval;
        this.intervalUnit = intervalUnit;
    }

    @Override
    public SysQuartzTriggerType triggerType() {
        return SysQuartzTriggerType.INTERVAL_CALENDAR;
    }

    @Override
    public void validate() {
        Assert.notNull((Object)this.interval, (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((this.interval > 0 ? 1 : 0) != 0, (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)this.intervalUnit), (String)"\u95f4\u9694\u65f6\u95f4\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    public Trigger buildTrigger() {
        CalendarIntervalTriggerImpl trigger = new CalendarIntervalTriggerImpl();
        DateBuilder.IntervalUnit unit = switch (this.intervalUnit) {
            default -> throw new IncompatibleClassChangeError();
            case IntervalUnit.MILLISECOND -> DateBuilder.IntervalUnit.MILLISECOND;
            case IntervalUnit.SECOND -> DateBuilder.IntervalUnit.SECOND;
            case IntervalUnit.MINUTE -> DateBuilder.IntervalUnit.MINUTE;
            case IntervalUnit.HOUR -> DateBuilder.IntervalUnit.HOUR;
            case IntervalUnit.DAY -> DateBuilder.IntervalUnit.DAY;
            case IntervalUnit.WEEK -> DateBuilder.IntervalUnit.WEEK;
            case IntervalUnit.MONTH -> DateBuilder.IntervalUnit.MONTH;
            case IntervalUnit.YEAR -> DateBuilder.IntervalUnit.YEAR;
        };
        trigger.setRepeatInterval(this.interval.intValue());
        trigger.setRepeatIntervalUnit(unit);
        return trigger;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public IntervalUnit getIntervalUnit() {
        return this.intervalUnit;
    }

    public void setIntervalUnit(IntervalUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public static enum IntervalUnit {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

