/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.quartz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.boot.util.StrUtil;
import com.elitescloud.boot.util.cron.CronUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzTriggerTimeValidator;
import com.elitescloud.cloudt.system.quartz.model.bo.SysQuartzJobSaveParam;
import com.elitescloud.cloudt.system.quartz.model.entity.SysQuartzJobDO;
import com.elitescloud.cloudt.system.quartz.service.SysQuartzMngService;
import com.elitescloud.cloudt.system.quartz.service.provider.SysQuartzJobDelegate;
import com.elitescloud.cloudt.system.quartz.service.repo.SysQuartzJobRepoProc;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysQuartzMngServiceImpl
implements SysQuartzMngService {
    private static final Logger logger = LoggerFactory.getLogger(SysQuartzMngServiceImpl.class);
    private static final String TRIGGER_IDENTIFIER_SUFFIX = "_trigger";
    @Autowired
    private ObjectProvider<SysQuartzTriggerTimeValidator> triggerTimeValidators;
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private SysQuartzJobRepoProc sysQuartzJobRepoProc;

    @Override
    public ApiResult<Boolean> started() {
        boolean started = this.isSchedulerStared();
        return ApiResult.ok((Object)started);
    }

    @Override
    public ApiResult<Boolean> validateCron(String cron) {
        boolean validated = CronUtil.validateCronExpression((String)cron);
        return ApiResult.ok((Object)validated);
    }

    @Override
    public ApiResult<List<String>> getNextFiredTime(String cron, Integer count) {
        List nextFiredTime;
        if (count == null) {
            count = 6;
        }
        if ((nextFiredTime = CronUtil.getNextTriggerTimes((String)cron, (int)count, time -> this.validateTriggerTime(DatetimeUtil.date2LocalDateTime((Date)time)) == null)).isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        return ApiResult.ok(nextFiredTime.stream().map(DatetimeUtil::toStr).toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> saveJob(SysQuartzJobSaveParam saveParam) {
        this.checkAndFillDefault(saveParam);
        this.saveJobInfo(saveParam);
        try {
            this.registerJob(saveParam);
        }
        catch (Exception e) {
            logger.error("\u6ce8\u518c\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u6ce8\u518c\u4efb\u52a1\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Throwable)e);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> pauseJob(String jobCode) {
        JobKey jobKey = this.getJobKey(jobCode);
        if (jobKey == null) {
            return ApiResult.fail((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        try {
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.pauseJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u6682\u505c\u4efb\u52a1\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Throwable)e);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> resumeJob(String jobCode) {
        JobKey jobKey = this.getJobKey(jobCode);
        if (jobKey == null) {
            return ApiResult.fail((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        try {
            if (!this.scheduler.checkExists(jobKey)) {
                return ApiResult.fail((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            this.scheduler.resumeJob(jobKey);
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u6062\u590d\u4efb\u52a1\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Throwable)e);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteJob(String jobCode) {
        JobKey jobKey = this.getJobKey(jobCode);
        if (jobKey == null) {
            return ApiResult.fail((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        try {
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u5220\u9664\u4efb\u52a1\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Throwable)e);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> runOnceJob(String jobCode) {
        JobKey jobKey = this.getJobKey(jobCode);
        if (jobKey == null) {
            return ApiResult.fail((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (!this.isSchedulerStared()) {
            return ApiResult.fail((String)"\u8c03\u5ea6\u5668\u672a\u542f\u52a8");
        }
        try {
            if (this.scheduler.checkExists(jobKey)) {
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put("__runonce", true);
                this.scheduler.triggerJob(jobKey, jobDataMap);
            }
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u8fd0\u884c\u4efb\u52a1\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Throwable)e);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> interruptJob(String jobCode) {
        JobKey jobKey = this.getJobKey(jobCode);
        if (jobKey == null) {
            return ApiResult.fail((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        try {
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.interrupt(jobKey);
            }
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u4e2d\u65ad\u4efb\u52a1\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Throwable)e);
        }
        return ApiResult.ok((Object)true);
    }

    private void registerJob(SysQuartzJobSaveParam saveParam) throws Exception {
        JobBuilder jobDetailBuilder = JobBuilder.newJob(SysQuartzJobDelegate.class).withIdentity(saveParam.getJobCode(), saveParam.getJobType().groupCode()).withDescription(saveParam.getJobType().description()).storeDurably();
        if (CollUtil.isNotEmpty(saveParam.getJobData())) {
            for (Map.Entry<String, String> entry : saveParam.getJobData().entrySet()) {
                jobDetailBuilder.usingJobData(entry.getKey(), entry.getValue());
            }
        }
        JobDetail jobDetail = jobDetailBuilder.build();
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(saveParam.getJobCode() + TRIGGER_IDENTIFIER_SUFFIX, saveParam.getJobType().groupCode() + TRIGGER_IDENTIFIER_SUFFIX).withSchedule(saveParam.getTrigger().buildScheduleBuilder()).startAt(saveParam.getStartTime()).endAt(saveParam.getEndTime());
        Trigger trigger = triggerBuilder.build();
        this.scheduler.scheduleJob(jobDetail, Set.of(trigger), true);
    }

    private void saveJobInfo(SysQuartzJobSaveParam saveParam) {
        SysQuartzJobDO jobInfo = this.sysQuartzJobRepoProc.getByJobCode(saveParam.getJobCode());
        if (jobInfo == null) {
            jobInfo = new SysQuartzJobDO();
            jobInfo.setJobCode(saveParam.getJobCode());
            jobInfo.setGroupCode(saveParam.getJobType().groupCode());
            jobInfo.setEnabled(true);
            jobInfo.setSysTenantId(saveParam.getTenantId());
        } else {
            Assert.isTrue((boolean)jobInfo.getGroupCode().equals(saveParam.getJobType().groupCode()), (String)"\u4efb\u52a1\u7ec4\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
            Assert.isTrue((boolean)ObjUtil.equals((Object)saveParam.getTenantId(), (Object)jobInfo.getSysTenantId()), (String)"\u4efb\u52a1\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        jobInfo.setJobName(saveParam.getJobName());
        jobInfo.setDescription(saveParam.getDescription());
        jobInfo.setJobClass(saveParam.getJobClass().getName());
        jobInfo.setJobDataJson(JSONUtil.toJsonString(saveParam.getJobData()));
        jobInfo.setTriggerType(saveParam.getTrigger().triggerType().name());
        jobInfo.setTriggerJson(JSONUtil.toJsonString((Object)saveParam.getTrigger()));
        jobInfo.setStarDate(DatetimeUtil.date2LocalDateTime((Date)saveParam.getStartTime()));
        jobInfo.setEndDate(DatetimeUtil.date2LocalDateTime((Date)saveParam.getEndTime()));
        this.sysQuartzJobRepoProc.save((Serializable)((Object)jobInfo));
    }

    private void checkAndFillDefault(SysQuartzJobSaveParam saveParam) {
        Assert.isTrue((boolean)this.isSchedulerStared(), (String)"\u8c03\u5ea6\u5668\u672a\u542f\u52a8", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveParam.getJobCode(), (String)"\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)saveParam.getJobType(), (String)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(saveParam.getJobClass(), (String)"\u4efb\u52a1\u6267\u884c\u5668\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)Job.class.isAssignableFrom(saveParam.getJobClass()), (String)"\u4e0d\u652f\u6301\u7684\u4efb\u52a1\u6267\u884c\u5668", (Object[])new Object[0]);
        try {
            Constructor<? extends Job> constructor = saveParam.getJobClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u4efb\u52a1\u6267\u884c\u5668\u7c7b\u672a\u5b9a\u4e49\u65e0\u53c2\u6784\u9020\u51fd\u6570");
        }
        Assert.notNull((Object)saveParam.getTrigger(), (String)"\u4efb\u52a1\u89e6\u53d1\u5668\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        saveParam.getTrigger().validate();
        if (saveParam.getStartTime() == null) {
            saveParam.setStartTime(new Date());
        }
    }

    private String validateTriggerTime(LocalDateTime time) {
        if (time == null) {
            return "\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (SysQuartzTriggerTimeValidator validator : this.triggerTimeValidators) {
            String result = validator.validate(time);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private JobKey getJobKey(String jobCode) {
        if (StrUtil.isBlank((CharSequence)jobCode)) {
            return null;
        }
        String groupCode = this.sysQuartzJobRepoProc.getJobGroupCode(jobCode);
        if (StrUtil.isBlank((CharSequence)groupCode)) {
            return null;
        }
        return JobKey.jobKey((String)jobCode, (String)groupCode);
    }

    private boolean isSchedulerStared() {
        try {
            return this.scheduler.isStarted();
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u83b7\u53d6\u8c03\u5ea6\u5668\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
    }
}

