package com.elitescloud.cloudt.system.quartz.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.quartz.service.SysQuartzMngService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/20 周六
 */
@RestController
@RequestMapping(value = "/mng/quartz", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class SysQuartzController {

    private SysQuartzMngService quartzService;

    @ApiOperation(value = "是否已启动")
    @GetMapping(value = "/started")
    public ApiResult<Boolean> started() {
        return quartzService.started();
    }

    @ApiOperation(value = "校验cron表达式")
    @ApiImplicitParam(name = "cron", value = "cron表达式", required = true)
    @GetMapping(value = "/validateCron")
    public ApiResult<Boolean> validateCron(@RequestParam(name = "cron") @NotBlank(message = "cron表达式为空") String cron) {
        return quartzService.validateCron(cron);
    }

    @ApiOperation(value = "获取下次执行时间")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "cron", value = "cron表达式", required = true),
            @ApiImplicitParam(name = "count", value = "获取的下次执行时间的数量", dataType = "int")
    })
    @GetMapping(value = "/getNextFiredTime")
    public ApiResult<List<String>> getNextFiredTime(@RequestParam(name = "cron") @NotBlank(message = "cron表达式为空") String cron,
                                                    @RequestParam(name = "count", required = false) Integer count) {
        return quartzService.getNextFiredTime(cron, count);
    }

    @Autowired
    public void setQuartzService(SysQuartzMngService quartzService) {
        this.quartzService = quartzService;
    }
}
