package com.elitescloud.cloudt.system.quartz.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/20 周六
 */
@Entity
@Table(name = "sys_quartz_trigger_record", indexes = {
        @Index(name = "idx_sys_quartz_trigger_recd_job", columnList = "jobCode"),
        @Index(name = "idx_sys_quartz_trigger_recd_firetime", columnList = "fireTime"),
})
@Comment("quartz任务调度记录")
@Getter
@Setter
public class SysQuartzTriggerRecordDO extends BaseModel {
    @Serial
    private static final long serialVersionUID = 5453449985691514844L;

    @Comment(value = "任务编码")
    @Column(nullable = false, length = 32)
    private String jobCode;

    @Comment(value = "任务实际触发时间")
    @Column(nullable = false)
    private LocalDateTime fireTime;

    @Comment(value = "任务调度触发时间")
    @Column()
    private LocalDateTime scheduledTime;

    @Comment(value = "任务触发类型")
    @Column(length = 32)
    private String firedType;

    @Comment(value = "任务完成时间")
    @Column()
    private LocalDateTime finishedTime;

    @Comment(value = "任务是否成功", defaultValue = "0")
    @Column()
    private Boolean success;

    @Comment(value = "任务失败信息")
    @Column()
    private String failMsg;

    @Comment(value = "任务完整失败信息")
    @Column()
    @Lob
    private String fullFailMsg;

    @Comment(value = "任务数据")
    @Column()
    @Lob
    private String jobDataMap;

    @Comment(value = "任务调度数据")
    @Column()
    @Lob
    private String triggerJobDataMap;
}
