package com.elitescloud.cloudt.system.seq.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.seq.model.vo.query.SeqRulePageQueryVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqRuleDetailsRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.resp.SeqRulePageRespVO;
import com.elitescloud.cloudt.system.seq.model.vo.save.SeqRuleSaveVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/11/14
 */
public interface SeqRuleMngService {

    /**
     * 更新
     *
     * @param id     ID
     * @param saveVO 保存信息
     * @return ID
     */
    ApiResult<Long> update(Long id, SeqRuleSaveVO saveVO);

    /**
     * 切换启用状态
     *
     * @param id ID
     * @return ID
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 获取详情
     *
     * @param id ID
     * @return 详情
     */
    ApiResult<SeqRuleDetailsRespVO> get(Long id);

    /**
     * 分页查询发号规则列表
     *
     * @param queryVO 查询参数
     * @return 规则列表
     */
    ApiResult<PagingVO<SeqRulePageRespVO>> pageMng(SeqRulePageQueryVO queryVO);

    /**
     * 生成示例代码
     *
     * @param id            ID
     * @param runtimeValues 运行时参数
     * @return 示例代码
     */
    ApiResult<String> getSample(Long id, List<String> runtimeValues);
}
