package com.elitescloud.cloudt.system.quartz.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.quartz.model.bo.SysQuartzJobSaveParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/20 周六
 */
public interface SysQuartzMngService {

    /**
     * 是否已启动
     *
     * @return
     */
    ApiResult<Boolean> started();

    /**
     * 校验cron表达式
     *
     * @param cron
     * @return
     */
    ApiResult<Boolean> validateCron(@NotBlank String cron);

    /**
     * 获取下一次执行时间
     *
     * @param cron
     * @param count
     * @return
     */
    ApiResult<List<String>> getNextFiredTime(@NotBlank String cron, Integer count);

    /**
     * 保存任务
     *
     * @param saveParam
     * @return
     */
    ApiResult<Boolean> saveJob(SysQuartzJobSaveParam saveParam);

    /**
     * 暂停任务
     *
     * @param jobCode
     * @return
     */
    ApiResult<Boolean> pauseJob(@NotBlank String jobCode);

    /**
     * 恢复任务
     *
     * @param jobCode
     * @return
     */
    ApiResult<Boolean> resumeJob(@NotBlank String jobCode);

    /**
     * 删除任务
     *
     * @param jobCode
     * @return
     */
    ApiResult<Boolean> deleteJob(@NotBlank String jobCode);

    /**
     * 运行一次任务
     *
     * @param jobCode
     * @return
     */
    ApiResult<Boolean> runOnceJob(@NotBlank String jobCode);

    /**
     * 中断任务
     *
     * @param jobCode
     * @return
     */
    ApiResult<Boolean> interruptJob(@NotBlank String jobCode);
}
