package com.elitescloud.cloudt.system.quartz.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.quartz.model.entity.QSysQuartzJobDO;
import com.elitescloud.cloudt.system.quartz.model.entity.SysQuartzJobDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/21 周日
 */
@Repository()
public class SysQuartzJobRepoProc extends BaseRepoProc<SysQuartzJobDO> {
    private static final QSysQuartzJobDO QDO = QSysQuartzJobDO.sysQuartzJobDO;

    public SysQuartzJobRepoProc() {
        super(QDO);
    }

    public boolean existsJobCode(@NotBlank String jobCode) {
        return super.exists(QDO.jobCode.eq(jobCode));
    }

    public SysQuartzJobDO getByJobCode(@NotBlank String jobCode) {
        return super.getOne(QDO.jobCode.eq(jobCode));
    }

    public String getJobGroupCode(@NotBlank String jobCode) {
        return super.getValueByValue(QDO.groupCode, QDO.jobCode, jobCode);
    }
}
